clear all

* Import and clean shocks data

cd ..\Inputs

import excel "Shocks.xlsx", ///
sheet(Sheet1) cellrange(A2) firstrow clear

foreach v of varlist ??? {
	destring `v', replace force
}

gen year=floor(Quarter)
gen quarter=(Quarter-year)*4+1

drop t Quarter
order year quarter

* Merge quarterly Economou oil price shocks
merge 1:1 year quarter using OILSHOCKSECONO_quarterly
drop _merge

* Merge actual output
merge 1:1 year quarter using GDPC96
drop _merge

* Chnage folder to output one

cd ..\Outputs

* Merge with Greenbook data
merge 1:1 year quarter using Data_GRE
drop _merge

* Merge with CBO data
merge 1:1 year quarter using Data_CBO
drop _merge

* Merge with SPF data
merge 1:1 year quarter using Data_SPF
drop _merge

* Merge with Orphanides data
merge 1:1 year quarter using Data_ORP
drop _merge

* Merge with vintages of GDP growth
merge 1:1 year quarter using VINRGDPG
drop _merge *ROUTPUT*

* Merge with Blanchard and Quah decomposition
merge 1:1 year quarter using BQ
drop _merge

merge 1:1 year quarter using BQfullsample
drop _merge

merge 1:1 year quarter using BQrollingwindow120
drop _merge

* Merge monetary policy shocks identified via a VAR
merge 1:1 year quarter using shocks_MPVAR
drop _merge

* Merge TFP data from Fernald
merge 1:1 year quarter using TFPFERNALD
drop _merge

* Merge quarterly Kilian oil price shocks
merge 1:1 year quarter using OILK
drop _merge

* Sort database
sort year quarter

* Create dummy for 911
capture drop D911
gen D911=(year==2001 & quarter==3)

* Purify the SPF shock
capture drop t*
gen tt=_n
tsset tt
gen dlogY=log(GDPC96/l.GDPC96)

reg  FP1SPF1 FP1SPFREV2 FP1SPFREV3 l(1/4).realtime_G 
predict sFP1SPF1, resid
label var sFP1SPF1 "Residualized Auerbach-Gorodnichenko fiscal shock"
drop dlogY

save COMB, replace 
